<?php
// /api/categories.php
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

require_once dirname(__DIR__) . '/backend/db.php';
$mysqli->set_charset('utf8mb4');

function slug(string $s): string {
  $s = trim($s);
  if ($s === '') return 'otros';
  $orig = $s;
  $t = @iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $s);
  if ($t !== false && $t !== null) $s = $t;
  $s = strtolower(preg_replace('/[^a-z0-9]+/', '-', $s));
  $s = preg_replace('/(^-+|-+$)/', '', $s);
  if ($s !== '') return $s;
  $s = strtolower($orig);
  $s = preg_replace('/[áàäâ]/u','a',$s);
  $s = preg_replace('/[éèëê]/u','e',$s);
  $s = preg_replace('/[íìïî]/u','i',$s);
  $s = preg_replace('/[óòöô]/u','o',$s);
  $s = preg_replace('/[úùüû]/u','u',$s);
  $s = preg_replace('/ñ/u','n',$s);
  $s = preg_replace('/[^a-z0-9]+/u','-',$s);
  $s = preg_replace('/(^-+|-+$)/','',$s);
  return $s ?: 'otros';
}

$out = [];

$sql = "
  SELECT c.category,
         c.n,
         COALESCE(ce.is_active, 1)  AS is_active,
         COALESCE(ce.message,  '')  AS message
  FROM (
    SELECT TRIM(COALESCE(category, categoria, '')) AS category,
           COUNT(*) AS n
    FROM productos
    WHERE TRIM(COALESCE(category, categoria, '')) <> ''
    GROUP BY 1
  ) AS c
  LEFT JOIN categorias_estado ce
    ON LOWER(TRIM(ce.category)) = LOWER(TRIM(c.category))
  ORDER BY c.category
";

try {
  if ($res = $mysqli->query($sql)) {
    while ($row = $res->fetch_assoc()) {
      $label = (string)$row['category'];
      $out[] = [
        'key'       => slug($label),   // compat
        'label'     => $label,         // compat
        'count'     => (int)$row['n'], // compat
        'category'  => $label,
        'slug'      => slug($label),
        'is_active' => (int)$row['is_active'],
        'message'   => (string)$row['message'],
      ];
    }
    $res->free();
  }
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false,'error'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
  exit;
}

echo json_encode($out, JSON_UNESCAPED_UNICODE);
