<?php
// /backend/pudiente.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

require_once dirname(__DIR__) . '/backend/db.php';  // 73 /home/USER/public_html/backend/db.php

$mysqli->set_charset('utf8mb4');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 0);

function out($arr, int $code=200){ http_response_code($code); echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }

$q = $mysqli->query("
  SELECT id, nombre, telefono,
         COALESCE(avatarURL,'') AS avatarURL,
         COALESCE(maxCumanaCoins,0) AS maxCumanaCoins,
         COALESCE(cumanaCoins,0)    AS cumanaCoins
  FROM usuarios
  ORDER BY COALESCE(maxCumanaCoins,0) DESC,
           COALESCE(cumanaCoins,0)    DESC,
           id ASC
  LIMIT 1
");
$top = $q ? $q->fetch_assoc() : null;
if (!$top) out(['success'=>false, 'error'=>'No hay usuarios']);

$avatarURL = trim((string)$top['avatarURL']);
$ver = time();
if ($avatarURL !== '') {
  $fsPath = __DIR__ . '/../' . ltrim($avatarURL, '/'); // ruta absoluta
  if (is_file($fsPath)) {
    $ver = (int) @filemtime($fsPath);
  }
  // anexa versión para romper caché en clientes
  $sep = (strpos($avatarURL, '?') !== false) ? '&' : '?';
  $avatarURL .= $sep . 'v=' . $ver;
}

out([
  'success' => true,
  'top' => [
    'id'             => (int)$top['id'],
    'nombre'         => $top['nombre'] ?? '',
    'telefono'       => $top['telefono'] ?? '',
    'avatarURL'      => $avatarURL, // <- ya viene versionada
    'maxCumanaCoins' => (int)$top['maxCumanaCoins']
  ]
]);
