<?php
$CSP_NONCE = base64_encode(random_bytes(16));
header(
  "Content-Security-Policy: ".
  "default-src 'self'; ".
  "base-uri 'none'; object-src 'none'; frame-ancestors 'none'; ".
  "img-src 'self' data: https:; ".
  "font-src 'self' data: https:; ".
  "style-src 'self' 'unsafe-inline'; ".
  "script-src 'self' 'nonce-$CSP_NONCE' https://cdn.jsdelivr.net; ".
  "connect-src 'self'; ".
  "form-action 'self'; ".
  "upgrade-insecure-requests"
);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Panel de Administración - TanBellaMiPea</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="stylesheet" href="/admin/admin.css?v=2025-08-14-124" />
</head>
<body>
  <div id="neon-alert" class="neon-alert"></div>

  <div id="admin-login-modal" class="admin-login-modal" style="display:flex;">
    <div class="admin-login-content">
      <button id="cerrar-login-admin" class="cerrar-modal-admin" type="button">&times;</button>
      <h2>🔐 Administrador</h2>
      <p>Introduce la clave</p>
      <input type="password" id="admin-password" placeholder="Clave de administrador" />
      <button id="admin-login-btn" type="button">Entrar</button>
    </div>
  </div>
  
  <main id="admin-panel" class="admin-page" style="display:none;">

  <div class="upload-modal">

    <div class="upload-box">
      <button class="upload-close" type="button" hidden aria-hidden="true"></button>
      <h3>Panel de Administración</h3>

      <section>
        <h4>Usuarios/Pagos/Canjes</h4>
        <button id="btn-ver-registros-admin" class="admin-btn" type="button">Ver Registros</button>
      </section>
      <hr />

      <section>
        <h4>Actualizar Stock</h4>
        <input type="file" id="excel-file" accept=".xlsx,.xls" class="file-btn" />
      </section>
      <hr />

      <section class="tasa-bcv-section">
        <h4>Actualizar tasa BCV</h4>
        <input type="text" id="manual-tasa" placeholder="Ejemplo: 8.75" />
        <button id="guardar-tasa" class="upload-label" type="button">Actualizar tasa</button>
      </section>
      <hr />

      <section class="ban-user-section">
        <h4>Banear usuario</h4>
        <input type="text" id="ban-phone" placeholder="Teléfono(11 dígitos)" maxlength="11" pattern="\d{11}" />
        <button id="ban-user-btn" class="upload-label" type="button">Banear</button>
      </section>
      <hr />

      <section class="promo-video-section admin-card">
        <h4>Subir video publicitario</h4>
        <input type="file" id="promo-video-file" accept="video/*" class="file-btn" />
      </section>
      <hr />

      <section id="cat-msg-box" class="admin-card">
        <h4>Mensaje por categoría</h4>
        <div class="catmsg-grid">
          <label for="cat-msg-select">Categoría</label>
          <select id="cat-msg-select">
            <option value="" disabled selected>Selecciona una categoría</option>
          </select>

          <label for="cat-msg-text">Mensaje (opcional)</label>
          <textarea id="cat-msg-text" rows="2" placeholder="Ej: Disponible de 12pm a 6pm, 2x1 hoy, etc."></textarea>

          <div class="catmsg-actions">
            <button id="cat-msg-save" type="button">Guardar</button>
            <button id="cat-msg-clear" type="button">Limpiar</button>
          </div>
        </div>
      </section>

      <hr />
      <section id="finanzas-section" class="admin-card">
        <button id="open-finanzas-modal" class="upload-label" type="button">📊 Finanzas &amp; Reportes</button>
      </section>

      <hr />
      <section id="availability-section" class="admin-card">
        <button id="open-availability-modal" class="upload-label" type="button">🗂 Disponibilidad por categoría</button>
      </section>

      <hr />
      <section id="product-section" class="product-add-section admin-card">
        <h4>Agregar producto</h4>
        <label for="prod-category">Categoría
          <input type="text" id="prod-category" placeholder="Ej: Cervezas" />
        </label>
        <label for="prod-name">Nombre
          <input type="text" id="prod-name" placeholder="Nombre del producto" />
        </label>
        <label for="prod-desc">Descripción
          <textarea id="prod-desc" rows="2" placeholder="Descripción (opcional)"></textarea>
        </label>
        <label for="prod-price">Precio (USD)
          <input type="number" id="prod-price" step="0.01" min="0" placeholder="0.00" />
        </label>
        <div class="product-image-upload">
          <input type="file" id="prod-image" accept="image/*" style="display:none;" />
          <label for="prod-image" class="upload-label" id="prod-image-label">📷 Seleccionar imagen</label>
          <span id="prod-image-name" class="image-name"></span>
        </div>
        <button id="prod-add-btn" class="upload-label" type="button">Añadir producto</button>
      </section>
    </div>
  </div>

  <div id="modal-usuarios-registrados" class="modal-usuarios-oculto" style="display:none;">
    <div class="modal-usuarios-contenido">
      <span id="cerrar-modal-usuarios" class="cerrar-modal-usuarios">&times;</span>
      <div class="tabs">
        <button id="tab-usuarios" class="active" type="button">Usuarios</button>
        <button id="tab-pagos" type="button">Confirmar CumaCoins</button>
        <button id="tab-solicitudes" type="button">Autorizar Canjes</button>
      </div>

      <div id="content-usuarios">
        <table class="tabla-usuarios">
          <thead>
            <tr>
              <th>Nombre</th>
              <th>Teléfono</th>
              <th>Coins</th>
              <th>Fecha</th>
            </tr>
          </thead>
          <tbody id="tbody-usuarios-registrados"></tbody>
        </table>
      </div>

      <div id="content-pagos" style="display:none;">
        <table id="tabla-pedidos" class="tabla-usuarios">
          <thead>
            <tr>
              <th>Orden N°</th>
              <th>ID</th>
              <th>Nombre</th>
              <th>Teléfono</th>
              <th>USD</th>
              <th>Bs</th>
              <th>Fecha</th>
              <th>Estado</th>
              <th>Acciones</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>

      <div id="content-solicitudes" style="display:none;">
        <table class="tabla-usuarios">
          <thead>
            <tr>
              <th>Nombre</th>
              <th>Premio</th>
              <th>Coins Necesarios</th>
              <th>Estado</th>
              <th>Fecha</th>
              <th>Acciones</th>
            </tr>
          </thead>
          <tbody id="tbody-solicitudes-canje"></tbody>
        </table>
      </div>
    </div>
  </div>

  <div id="finanzas-modal" class="modal-finanzas" style="display:none;">
    <div class="finanzas-modal-content">
      <span id="finanzas-close" class="close-modal">&times;</span>
      <h4>Finanzas</h4>
      <div class="finanzas-controls">
        <label for="finanzas-desde">Desde:
          <input type="date" id="finanzas-desde" />
        </label>
        <label for="finanzas-hasta">Hasta:
          <input type="date" id="finanzas-hasta" />
        </label>
        <button id="finanzas-cargar-btn" class="upload-label" type="button">Actualizar resumen</button>
      </div>
      <div id="finanzas-kpis" class="finanzas-kpis"></div>
      <table id="finanzas-table" class="tabla-usuarios finanzas-table">
        <thead>
          <tr>
            <th>Fecha</th>
            <th>Recargas USD</th>
            <th>Canjes Coins</th>
            <th># Recargas</th>
            <th># Canjes</th>
          </tr>
        </thead>
        <tbody id="finanzas-tbody"></tbody>
      </table>
      <div class="finanzas-export">
        <button id="finanzas-export-csv" class="upload-label" type="button">📄 Exportar CSV</button>
        <button id="finanzas-export-excel" class="upload-label" type="button">📈 Exportar Excel</button>
      </div>
    </div>
  </div>

  <div id="availability-modal" class="modal-finanzas" style="display:none;">
    <div class="finanzas-modal-content">
      <span id="availability-close" class="close-modal">&times;</span>
      <section id="availability-box" class="admin-card">
        <h4>Disponibilidad por categoría</h4>
        <div class="av-toolbar">
          <div class="av-row">
            <label class="av-label" for="av-cat">Categoría</label>
            <select id="av-cat"></select>
            <input id="av-search" type="text" placeholder="Buscar por nombre…" />
          </div>
        </div>
        <div id="av-list" class="av-list"></div>
      </section>
    </div>
  </div>

  <div id="success-modal" class="modal" style="display:none;">
    <div class="modal-content">
      <p>✅ Archivo cargado satisfactoriamente</p>
    </div>
  </div>

<script nonce="<?= $CSP_NONCE ?>">window.BACKEND = '/api/';</script>
<script nonce="<?= $CSP_NONCE ?>">window.BACKEND_AUTH = '/backend/';</script>

<script src="https://cdn.jsdelivr.net/npm/xlsx@0.18.5/dist/xlsx.full.min.js" defer></script>
<script src="/admin-loader.js?v=68" defer></script>


 
</body>
</html>
