<?php
// backend/toggle-product.php — Cambia disponibilidad is_active de un producto
// Método: POST (x-www-form-urlencoded o JSON)
// Parámetros: id (int), available=1|0 (o is_active)
// Protegido por sesión admin + CSRF (usa guard.php)
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

require_once __DIR__ . '/guard.php';
require_admin();
require_csrf_for_write();

require_once __DIR__ . '/db.php';
$mysqli->set_charset('utf8mb4');

function out($arr, int $code=200){ http_response_code($code); echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }

// Parse body tolerantemente (JSON o form)
$raw = file_get_contents('php://input');
$asJson = json_decode($raw, true);
$id  = isset($_POST['id']) ? (int)$_POST['id'] : (int)($asJson['id'] ?? 0);
$val = $_POST['available'] ?? $_POST['is_active'] ?? ($asJson['available'] ?? $asJson['is_active'] ?? null);

if ($id <= 0) out(['success'=>false,'error'=>'ID inválido'], 400);
$available = (string)$val;
$available = ($available === '1' || $available === 'true' || $available === 'on' || $available === 'yes' || $available === 'si');

try {
  $st = $mysqli->prepare('UPDATE productos SET is_active=? WHERE id=?');
  $i  = $available ? 1 : 0;
  $st->bind_param('ii', $i, $id);
  $st->execute();
  $ok = ($st->affected_rows >= 0);
  $st->close();

  // Devuelve estado actual
  $st2 = $mysqli->prepare('SELECT id, is_active FROM productos WHERE id=?');
  $st2->bind_param('i', $id);
  $st2->execute();
  $row = $st2->get_result()->fetch_assoc();
  $st2->close();

  out(['success'=>$ok, 'id'=>$id, 'is_active'=> (int)($row['is_active'] ?? $i)]);
} catch (Throwable $e) {
  out(['success'=>false, 'error'=>$e->getMessage()], 500);
}
