<?php
// /backend/delete-product.php — elimina un producto por ID (y su imagen si existe)
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');
header('Access-Control-Allow-Origin: *');

$requireGuardIncluded = require_once __DIR__ . '/guard.php';
require_admin();
require_csrf_for_write();
require_once __DIR__ . '/db.php';
$mysqli->set_charset('utf8mb4');
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

function out(array $arr, int $code = 200): void {
    http_response_code($code);
    echo json_encode($arr, JSON_UNESCAPED_UNICODE);
    exit;
}

// Solo permitir POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    out(['success' => false, 'error' => 'Método no soportado'], 405);
}

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) {
    out(['success' => false, 'error' => 'ID inválido'], 400);
}

try {
    // Obtener imagen y verificar existencia antes de borrar
    $st = $mysqli->prepare("SELECT img FROM productos WHERE id=? LIMIT 1");
    $st->bind_param('i', $id);
    $st->execute();
    $row = $st->get_result()->fetch_assoc();
    $st->close();
    if (!$row) {
        out(['success' => false, 'error' => 'Producto no encontrado'], 404);
    }
    $img = trim((string)($row['img'] ?? ''));
    // Eliminar de la base de datos
    $st = $mysqli->prepare("DELETE FROM productos WHERE id=?");
    $st->bind_param('i', $id);
    $st->execute();
    $st->close();
    // Eliminar imagen del sistema de archivos si existe y no es placeholder
    if ($img !== '') {
        $docroot = realpath(dirname(__DIR__));
        $fs = $docroot . (strpos($img, '/') === 0 ? $img : ('/'.$img));
        if (is_file($fs)) @unlink($fs);
    }
    out(['success' => true]);
} catch (Throwable $e) {
    out(['success' => false, 'error' => 'Error: ' . $e->getMessage()], 500);
}