<?php
// /backend/category-settings.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 0);

require_once __DIR__ . '/guard.php';
require_once __DIR__ . '/db.php';

$mysqli->set_charset('utf8mb4');
require_admin();

function out($arr, int $code = 200) {
  http_response_code($code);
  echo json_encode($arr, JSON_UNESCAPED_UNICODE);
  exit;
}

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
if (in_array($method, ['POST','PUT','PATCH','DELETE'], true)) {
  require_csrf_for_write();
}

if ($method === 'GET') {
  try {
    $rows = [];
    $q = "SELECT TRIM(category) AS category,
                 is_active,
                 COALESCE(message,'') AS message,
                 updated_at
          FROM categorias_estado";
    $res = $mysqli->query($q);
    while ($r = $res->fetch_assoc()) $rows[$r['category']] = $r;
    out(['success'=>true,'data'=>$rows]);
  } catch (Throwable $e) {
    out(['success'=>false,'error'=>$e->getMessage()], 500);
  }
}

if ($method === 'POST') {
  $raw = file_get_contents('php://input');
  $j = json_decode($raw, true) ?? [];

  $accion   = strtolower(trim((string)($j['accion'] ?? '')));
  // Importante: guardamos la categoría **exactamente como viene** pero TRIM para evitar espacios raros
  $category = trim((string)($j['category'] ?? ''));
  // Nunca castees a string y luego intentes mandar NULL: usa NULLIF en SQL
  $message  = isset($j['message']) ? trim((string)$j['message']) : '';

  if ($category === '') out(['success'=>false,'error'=>'Categoría requerida'], 400);

  try {
    if ($accion === 'set_message') {
      // Guarda mensaje; si viene vacío => NULL
      $sql = "
        INSERT INTO categorias_estado (category, is_active, message)
        VALUES (TRIM(?), 1, NULLIF(?, ''))
        ON DUPLICATE KEY UPDATE
          message   = VALUES(message),
          updated_at = CURRENT_TIMESTAMP
      ";
      $stmt = $mysqli->prepare($sql);
      $stmt->bind_param('ss', $category, $message);
      $stmt->execute();
      $stmt->close();
      out(['success'=>true, 'saved'=>['category'=>$category,'message'=>$message]]);
    }

    if ($accion === 'clear_message') {
      $sql = "
        INSERT INTO categorias_estado (category, is_active, message)
        VALUES (TRIM(?), 1, NULL)
        ON DUPLICATE KEY UPDATE
          message = NULL,
          updated_at = CURRENT_TIMESTAMP
      ";
      $stmt = $mysqli->prepare($sql);
      $stmt->bind_param('s', $category);
      $stmt->execute();
      $stmt->close();
      out(['success'=>true]);
    }

    if ($accion === 'set_active') {
      $is_active = (int)($j['is_active'] ?? 1);
      $sql = "
        INSERT INTO categorias_estado (category, is_active, message)
        VALUES (TRIM(?), ?, NULL)
        ON DUPLICATE KEY UPDATE
          is_active = VALUES(is_active),
          updated_at = CURRENT_TIMESTAMP
      ";
      $stmt = $mysqli->prepare($sql);
      $stmt->bind_param('si', $category, $is_active);
      $stmt->execute();
      $stmt->close();
      out(['success'=>true]);
    }

    out(['success'=>false,'error'=>'Acción no soportada'], 400);
  } catch (Throwable $e) {
    out(['success'=>false,'error'=>$e->getMessage()], 500);
  }
}

out(['success'=>false,'error'=>'Método no permitido'], 405);
