CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120), email VARCHAR(160) UNIQUE, phone VARCHAR(40),
  password_hash VARCHAR(255), role ENUM('admin','customer') DEFAULT 'customer',
  status ENUM('active','banned') DEFAULT 'active', created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(120) UNIQUE, slug VARCHAR(140) UNIQUE,
  message VARCHAR(255) NULL, is_active TINYINT(1) DEFAULT 1
);
CREATE TABLE IF NOT EXISTS products (
  id INT AUTO_INCREMENT PRIMARY KEY,
  sku VARCHAR(60) UNIQUE, name VARCHAR(160), description TEXT, category_id INT,
  image_url TEXT, price DECIMAL(10,2), is_active TINYINT(1) DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
CREATE TABLE IF NOT EXISTS orders (
  id INT AUTO_INCREMENT PRIMARY KEY, user_id INT, total DECIMAL(10,2),
  status ENUM('pending','paid','completed','cancelled') DEFAULT 'pending',
  payment_method VARCHAR(60), delivery_method VARCHAR(60), channel VARCHAR(40) DEFAULT 'whatsapp',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE IF NOT EXISTS order_items (
  id INT AUTO_INCREMENT PRIMARY KEY, order_id INT, product_id INT, quantity INT, unit_price DECIMAL(10,2)
);
CREATE TABLE IF NOT EXISTS loyalty_ledger (
  id INT AUTO_INCREMENT PRIMARY KEY, user_id INT, order_id INT NULL, points_delta INT,
  reason ENUM('sale','redemption','adjustment') DEFAULT 'sale', created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE IF NOT EXISTS rewards (
  id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(160), points_cost INT, is_active TINYINT(1) DEFAULT 1
);
CREATE TABLE IF NOT EXISTS redemptions (
  id INT AUTO_INCREMENT PRIMARY KEY, user_id INT, reward_id INT,
  status ENUM('pending','approved','rejected','delivered') DEFAULT 'pending',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, resolved_at TIMESTAMP NULL
);
CREATE TABLE IF NOT EXISTS chat_channels ( id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(80), type ENUM('global','private') DEFAULT 'global');
CREATE TABLE IF NOT EXISTS chat_messages (
  id INT AUTO_INCREMENT PRIMARY KEY, channel_id INT, from_user_id INT, to_user_id INT NULL,
  content TEXT, file_url TEXT NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, is_deleted TINYINT(1) DEFAULT 0
);
CREATE TABLE IF NOT EXISTS settings ( k VARCHAR(80) PRIMARY KEY, v TEXT );
