<?php
// /backend/register.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

require_once dirname(__DIR__) . '/backend/db.php'; 
$mysqli->set_charset('utf8mb4');

try {
  $data = json_decode(file_get_contents('php://input'), true);
  if (!$data || !isset($data['nombre'], $data['telefono'])) {
    throw new Exception('Datos incompletos');
  }

  $nombre   = trim((string)$data['nombre']);
  $telefono = preg_replace('/\D+/', '', (string)$data['telefono']);
  if ($nombre === '' || $telefono === '') {
    throw new Exception('Nombre y teléfono son obligatorios');
  }

  // ¿Existe ya?
  $stmt = $mysqli->prepare("SELECT id, nombre, telefono, cumanaCoins, maxCumanaCoins, fechaRegistro, IFNULL(banned,0) AS banned, avatarURL FROM usuarios WHERE telefono=? LIMIT 1");
  $stmt->bind_param('s', $telefono);
  $stmt->execute();
  $existente = $stmt->get_result()->fetch_assoc();
  $stmt->close();

  if ($existente) {
    echo json_encode(['success'=>true, 'usuario'=>$existente], JSON_UNESCAPED_UNICODE);
    exit;
  }

  $coins         = 10;
  $maxCuma       = 10;
  $fechaRegistro = date('Y-m-d H:i:s');

  $stmt = $mysqli->prepare("INSERT INTO usuarios (nombre, telefono, cumanaCoins, maxCumanaCoins, fechaRegistro) VALUES (?,?,?,?,?)");
  $stmt->bind_param('ssiis', $nombre, $telefono, $coins, $maxCuma, $fechaRegistro);
  $stmt->execute();
  $stmt->close();

  // Leer y devolver el usuario recién creado
  $stmt = $mysqli->prepare("SELECT id, nombre, telefono, cumanaCoins, maxCumanaCoins, fechaRegistro, IFNULL(banned,0) AS banned, avatarURL FROM usuarios WHERE telefono=? LIMIT 1");
  $stmt->bind_param('s', $telefono);
  $stmt->execute();
  $usuario = $stmt->get_result()->fetch_assoc();
  $stmt->close();

  echo json_encode(['success'=>true, 'usuario'=>$usuario], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false, 'error'=>$e->getMessage()]);
}
