<?php
header('Content-Type: application/json');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');
ini_set('display_errors', 1); error_reporting(E_ALL);
require_once dirname(__DIR__) . '/backend/db.php';  

try {
    // Leer y validar datos
    $data = json_decode(file_get_contents("php://input"), true);
    if (!$data || !isset($data['telefono'])) {
        throw new Exception('Teléfono requerido');
    }

    // Limpiar el teléfono (igual que en register.php)
    $telefono = trim($data['telefono']);
    $telefono = preg_replace('/[^0-9]/', '', $telefono);

    // Debug
    error_log("Intento de login con teléfono: $telefono");

    // Usar prepared statement (más seguro que real_escape_string)
    $stmt = $mysqli->prepare("SELECT * FROM usuarios WHERE telefono = ? LIMIT 1");
    if (!$stmt) {
        throw new Exception('Error en la consulta: ' . $mysqli->error);
    }

    $stmt->bind_param("s", $telefono);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();

    if ($user) {
        error_log("Login exitoso para usuario: " . $user['nombre']);
        // Limpiamos datos sensibles si los hubiera
        unset($user['password']); // si tienes campo password
        echo json_encode([
            'success' => true,
            'usuario' => $user
        ]);
    } else {
        error_log("Usuario no encontrado: $telefono");
        echo json_encode([
            'success' => false,
            'error' => 'Número no registrado'
        ]);
    }

} catch(Exception $e) {
    error_log("Error en login: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>