-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Servidor: localhost:3306
-- Tiempo de generación: 12-09-2025 a las 02:01:55
-- Versión del servidor: 10.11.14-MariaDB
-- Versión de PHP: 8.4.11

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `superca1_demo`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `categorias_estado`
--

CREATE TABLE `categorias_estado` (
  `category` varchar(64) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `message` varchar(255) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `categorias_estado`
--

INSERT INTO `categorias_estado` (`category`, `is_active`, `message`, `updated_at`) VALUES
('Audifonos', 1, NULL, '2025-09-12 03:00:11'),
('categoria-a', 1, 'Oferta semanal', '2025-09-10 14:23:59'),
('categoria-b', 1, 'Disponible pronto', '2025-09-10 14:23:59');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `chat`
--

CREATE TABLE `chat` (
  `id` int(11) NOT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `nombre` varchar(100) DEFAULT NULL,
  `texto` text DEFAULT NULL,
  `reply_to` int(11) DEFAULT NULL,
  `privado` tinyint(1) NOT NULL DEFAULT 0,
  `para_telefono` varchar(20) DEFAULT NULL,
  `fecha` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `chat_adjuntos`
--

CREATE TABLE `chat_adjuntos` (
  `id` int(10) UNSIGNED NOT NULL,
  `chat_id` int(11) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `mime_type` varchar(100) NOT NULL,
  `file_size` int(10) UNSIGNED NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `consent_events`
--

CREATE TABLE `consent_events` (
  `id` bigint(20) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `session_id` varchar(64) DEFAULT NULL,
  `type` enum('privacy','terms','cookies','optout_sale','optout_ads','limit_sensitive','gpc') NOT NULL,
  `version` varchar(20) DEFAULT '',
  `consent` tinyint(1) NOT NULL,
  `prefs` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`prefs`)),
  `jurisdiction` varchar(16) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pedidos`
--

CREATE TABLE `pedidos` (
  `id` int(11) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  `nombre` varchar(100) DEFAULT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `montoUsd` decimal(10,2) DEFAULT NULL,
  `detalle` text DEFAULT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `tasaBCV` decimal(10,2) DEFAULT 0.00,
  `estado` enum('pendiente','aprobado','rechazado') DEFAULT 'pendiente',
  `order_code` varchar(32) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `processedAt` datetime DEFAULT NULL,
  `processedBy` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Volcado de datos para la tabla `pedidos`
--

INSERT INTO `pedidos` (`id`,`userId`,`nombre`,`telefono`,`montoUsd`,`detalle`,`fecha`,`tasaBCV`,`estado`,`order_code`,`created_at`,`processedAt`,`processedBy`) VALUES
(1,1,'Demo Uno','555000001',29.90,'[{"id":"1","name":"Producto Genérico A","price":9.9,"qty":3}]','2025-01-10 12:00:00',1.00,'aprobado','PEA-1001','2025-01-10 12:00:00','2025-01-10 13:00:00','admin'),
(2,2,'Demo Dos','555000002',14.50,'[{"id":"2","name":"Producto Genérico B","price":14.5,"qty":1}]','2025-01-12 16:30:00',1.00,'pendiente','PEA-1002','2025-01-12 16:30:00',NULL,NULL);
-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `productos`
--

CREATE TABLE `productos` (
  `id` int(11) NOT NULL,
  `category` varchar(60) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `productos`
--

INSERT INTO `productos` (`id`, `category`, `name`, `desc`, `price`, `img`, `is_active`) VALUES
(1, 'categoria-a', 'Producto Genérico A', 'Descripción A', 9.90, '/img/producto_a.jpg', 1),
(2, 'categoria-b', 'Producto Genérico B', 'Descripción B', 14.50, '/img/producto_b.jpg', 1),
(3, 'Audifonos', 'pk40', 'Inhalambricos bateria duradera', 3.00, '/imgproductos/audifonos/Swing8.webp', 1);

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `products`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `products` (
`id` int(11)
,`category` varchar(60)
,`name` varchar(100)
,`desc` mediumtext
,`price` decimal(10,2)
,`img` varchar(255)
,`is_active` tinyint(1)
);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `solicitudes`
--

CREATE TABLE `solicitudes` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `tipo` enum('canjear') NOT NULL,
  `monto` int(11) NOT NULL,
  `estado` enum('pendiente','aprobada','rechazada') NOT NULL DEFAULT 'pendiente',
  `canje_code` varchar(32) NOT NULL,
  `notas` text DEFAULT NULL,
  `createdAt` datetime NOT NULL DEFAULT current_timestamp(),
  `approvedAt` datetime DEFAULT NULL,
  `approvedBy` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tasa_bcv`
--

CREATE TABLE `tasa_bcv` (
  `id` int(11) NOT NULL,
  `tasa` decimal(12,4) NOT NULL,
  `fecha` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Volcado de datos para la tabla `tasa_bcv`
--

INSERT INTO `tasa_bcv` (`id`,`tasa`,`fecha`) VALUES (1,1.0000,'2025-01-01 00:00:00');
-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `nombre` varchar(80) NOT NULL,
  `telefono` varchar(20) NOT NULL,
  `banned` tinyint(1) NOT NULL DEFAULT 0,
  `cumanaCoins` int(11) DEFAULT 10,
  `fechaRegistro` datetime DEFAULT current_timestamp(),
  `maxCumanaCoins` int(11) DEFAULT 10,
  `avatarURL` varchar(500) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id`,`nombre`,`telefono`,`banned`,`cumanaCoins`,`fechaRegistro`,`maxCumanaCoins`,`avatarURL`) VALUES
(1,'Demo Uno','555000001',0,120,'2025-01-01 12:00:00',120,NULL),
(2,'Demo Dos','555000002',0,20,'2025-01-02 12:00:00',20,NULL);
--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `categorias_estado`
--
ALTER TABLE `categorias_estado`
  ADD PRIMARY KEY (`category`);

--
-- Indices de la tabla `chat`
--
ALTER TABLE `chat`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_chat_fecha` (`fecha`),
  ADD KEY `idx_reply_to` (`reply_to`),
  ADD KEY `idx_privado` (`privado`),
  ADD KEY `idx_para` (`para_telefono`);

--
-- Indices de la tabla `chat_adjuntos`
--
ALTER TABLE `chat_adjuntos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_chat_adjuntos_chat_id` (`chat_id`);

--
-- Indices de la tabla `consent_events`
--
ALTER TABLE `consent_events`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user` (`user_id`),
  ADD KEY `idx_sess` (`session_id`),
  ADD KEY `idx_type_time` (`type`,`created_at`);

--
-- Indices de la tabla `pedidos`
--
ALTER TABLE `pedidos`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_pedidos_order_code` (`order_code`),
  ADD UNIQUE KEY `uniq_order_code` (`order_code`),
  ADD KEY `idx_pedidos_estado_fecha` (`estado`,`created_at`,`id`);

--
-- Indices de la tabla `productos`
--
ALTER TABLE `productos`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `solicitudes`
--
ALTER TABLE `solicitudes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_canje_code` (`canje_code`),
  ADD UNIQUE KEY `uniq_canje_code` (`canje_code`),
  ADD KEY `estado` (`estado`),
  ADD KEY `userId` (`userId`),
  ADD KEY `idx_solicitudes_estado_fecha` (`estado`,`id`),
  ADD KEY `idx_solicitudes_estado_createdAt` (`estado`,`createdAt`);

--
-- Indices de la tabla `tasa_bcv`
--
ALTER TABLE `tasa_bcv`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_telefono` (`telefono`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `chat`
--
ALTER TABLE `chat`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `chat_adjuntos`
--
ALTER TABLE `chat_adjuntos`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `consent_events`
--
ALTER TABLE `consent_events`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `pedidos`
--
ALTER TABLE `pedidos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de la tabla `productos`
--
ALTER TABLE `productos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de la tabla `solicitudes`
--
ALTER TABLE `solicitudes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `tasa_bcv`
--
ALTER TABLE `tasa_bcv`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

-- --------------------------------------------------------

--
-- Estructura para la vista `products`
--
DROP VIEW IF EXISTS `products`;
DROP TABLE IF EXISTS `products`;

CREATE VIEW `products` AS SELECT `productos`.`id` AS `id`, `productos`.`category` AS `category`, `productos`.`name` AS `name`, `productos`.`desc` AS `desc`, `productos`.`price` AS `price`, `productos`.`img` AS `img`, `productos`.`is_active` AS `is_active` FROM `productos` ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
