<?php
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

// upload_promo.php
// Protecciones de acceso
require_once __DIR__ . '/guard.php';
require_admin();
require_csrf_for_write();

header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/db.php'; // DB connection

// Recomendado: límites (asegúrate en cPanel/php.ini):
// upload_max_filesize >= 50M, post_max_size >= 50M
// También puedes poner un .user.ini en /backend/ con esas directivas.

$UPLOAD_DIR = dirname(__DIR__) . '/uploads/promo/'; // ../uploads/promo/
$PUBLIC_URL = '/uploads/promo/';                     // URL pública

// Crea el directorio si no existe
if (!is_dir($UPLOAD_DIR)) { mkdir($UPLOAD_DIR, 0775, true); }

if (!isset($_FILES['video']) || $_FILES['video']['error'] !== UPLOAD_ERR_OK) {
  echo json_encode(['success'=>false,'error'=>'No llegó el archivo']); exit;
}

$f = $_FILES['video'];
$maxSize = 100 * 1024 * 1024; // 100MB
if ($f['size'] <= 0 || $f['size'] > $maxSize) {
  echo json_encode(['success'=>false,'error'=>'Tamaño inválido (max 100MB)']); exit;
}

// Validar extensión/MIME
$allowedExt = ['mp4','webm','ogg'];
$ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
if (!in_array($ext, $allowedExt)) {
  echo json_encode(['success'=>false,'error'=>'Formato no permitido (mp4/webm/ogg)']); exit;
}

// Nombre único (timestamp + aleatorio)
$rand = bin2hex(random_bytes(4));
$filename = 'promo_' . date('Ymd_His') . '_' . $rand . '.' . $ext;
$destPath = $UPLOAD_DIR . $filename;

if (!move_uploaded_file($f['tmp_name'], $destPath)) {
  echo json_encode(['success'=>false,'error'=>'No se pudo guardar el archivo']); exit;
}

// Actualizar config JSON
$configPath = $UPLOAD_DIR . 'promo_config.json';
$config = [
  'active'   => true,
  'src'      => $PUBLIC_URL . $filename,
  'delayMs'  => 3000,
  'showEveryHours' => 24,
  'updatedAt'=> date('c')
];
file_put_contents($configPath, json_encode($config, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));

echo json_encode(['success'=>true,'src'=>$config['src']]);
