<?php
header('Content-Type: application/json');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');
include 'db.php';

// Protecciones para admin
require_once __DIR__ . '/guard.php';
require_admin();
require_csrf_for_write();

$data = json_decode(file_get_contents("php://input"), true);
$nuevaTasa = floatval($data['tasa'] ?? 0);

if ($nuevaTasa <= 0) {
    echo json_encode(['error' => 'Tasa inválida']);
    exit;
}

$sql = "INSERT INTO tasa_bcv (tasa) VALUES ($nuevaTasa)";
if ($mysqli->query($sql)) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['error' => 'No se pudo guardar']);
}
?>