<?php
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');
require_once dirname(__DIR__) . '/backend/db.php';
require_once dirname(__DIR__) . '/backend/phone_utils.php';

$phone_e164 = normalize_to_e164($_GET['phone_e164'] ?? ($_GET['telefono'] ?? null), $_GET['country'] ?? null);
if (!$phone_e164) {
  echo json_encode(['success'=>false,'error'=>'Teléfono requerido'], JSON_UNESCAPED_UNICODE);
  exit;
}

try {
  $stmt = $mysqli->prepare("SELECT COALESCE(puntos,0) AS coins FROM usuarios WHERE phone_e164 = ? LIMIT 1");
  $stmt->bind_param('s', $phone_e164);
  $stmt->execute();
  $res = $stmt->get_result();
  $user = $res ? $res->fetch_assoc() : null;
  $stmt->close();
  if ($user) {
    echo json_encode(['success'=>true,'coins'=>(int)$user['coins']], JSON_UNESCAPED_UNICODE);
  } else {
    echo json_encode(['success'=>false,'error'=>'No encontrado'], JSON_UNESCAPED_UNICODE);
  }
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false,'error'=>'DB error'], JSON_UNESCAPED_UNICODE);
}
?>