<?php
// backend/auth.php
declare(strict_types=1);
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';     // lo que uses para conectar/validar
// si tienes helpers de sesión iguales a guard.php, inclúyelos antes de session_start

// -----------------------------------------------------------------------------
// Implementación de validar_login()
//
// Esta función comprueba que el número de teléfono y la contraseña enviados
// coincidan con las credenciales de administrador definidas en config.php.
// Soporta tanto contraseñas en texto plano (ADMIN_PASS) como hashes Bcrypt
// (ADMIN_PASS_HASH). Si se desea autenticar a otros usuarios desde la base de
// datos, ampliar aquí la lógica según sea necesario.
if (!function_exists('validar_login')) {
    /**
     * Valida las credenciales de inicio de sesión.
     *
     * @param string $user Número de teléfono (sólo dígitos)
     * @param string $pass Contraseña introducida
     * @return bool true si las credenciales son correctas
     */
    function validar_login(string $user, string $pass): bool {
        // Usuario esperado (teléfono) sin caracteres no numéricos
        $expected = defined('ADMIN_USER') ? preg_replace('/\D+/', '', (string)ADMIN_USER) : '';
        // 1) Verificación usando hash (ADMIN_PASS_HASH)
        if (defined('ADMIN_PASS_HASH')) {
            $hash = (string)ADMIN_PASS_HASH;
            if ($hash !== '' && $expected !== '' && $user === $expected) {
                if (password_verify($pass, $hash)) {
                    return true;
                }
            }
        }
        // 2) Verificación de contraseña en texto plano (ADMIN_PASS)
        if (defined('ADMIN_PASS') && $expected !== '') {
            $plain = (string)ADMIN_PASS;
            if ($user === $expected && $pass === $plain) {
                return true;
            }
        }
        // 3) Aquí podría implementarse autenticación contra tabla de usuarios
        return false;
    }
}

if (session_status() !== PHP_SESSION_ACTIVE) {
  session_set_cookie_params([
    'lifetime'=>0,'path'=>'/','secure'=>(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off'),
    'httponly'=>true,'samesite'=>'Lax'
  ]);
  session_start();
}

header('Content-Type: application/json; charset=utf-8');

$action = $_GET['action'] ?? '';
if ($action !== 'login') {
  echo json_encode(['success'=>false,'error'=>'Acción inválida']);
  exit;
}

$user = preg_replace('/\D+/','', $_POST['user'] ?? '');
$pass = $_POST['pass'] ?? '';

// TODO: valida con tu misma l«Ñgica de usuarios.php (consulta DB, etc.)

// Validar las credenciales. Se delega en validar_login(), definida arriba.
$ok = validar_login($user, $pass);
$telSesion = $user;                          // teléfono del usuario logueado

if (!$ok) {
  echo json_encode(['success'=>false,'error'=>'Credenciales inválidas']);
  exit;
}

// marcar admin si coincide con config
$adminConf = preg_replace('/\D+/','', (defined('ADMIN_USER')? ADMIN_USER : ''));
$_SESSION['is_admin']   = ($telSesion !== '' && $telSesion === $adminConf);
$_SESSION['admin_user'] = $telSesion;
$_SESSION['csrf']       = $_SESSION['csrf'] ?? bin2hex(random_bytes(32));

echo json_encode(['success'=>true, 'csrf'=>$_SESSION['csrf'], 'is_admin'=>$_SESSION['is_admin']]);
