<?php
// /backend/usuarios.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');
header('Access-Control-Allow-Origin: *');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once dirname(__DIR__) . '/backend/db.php'; 
$mysqli->set_charset('utf8mb4');

function out($arr, int $code = 200): void {
  http_response_code($code);
  echo json_encode($arr, JSON_UNESCAPED_UNICODE);
  exit;
}
function tableExists(mysqli $db, string $name): bool {
  $name = $db->real_escape_string($name);
  $res  = $db->query("SHOW TABLES LIKE '$name'");
  return $res && $res->num_rows > 0;
}

// 1) Listado para admin (array directo)
if (isset($_GET['listar'])) {
  if (!tableExists($mysqli, 'usuarios')) out([]);
  $limit = isset($_GET['limit']) ? max(1, min(1000, (int)$_GET['limit'])) : 500;
  $sql = "SELECT id, nombre, telefono, 
                 COALESCE(puntos,0)    AS puntos,
                 COALESCE(maxpuntos,0) AS maxpuntos,
                 COALESCE(banned,0)         AS banned,
                 fechaRegistro, avatarURL
          FROM usuarios
          ORDER BY COALESCE(fechaRegistro,'1970-01-01') DESC
          LIMIT $limit";
  $res = $mysqli->query($sql);
  $rows = [];
  while ($r = $res->fetch_assoc()) {
    $rows[] = [
      'id'             => (int)$r['id'],
      'nombre'         => $r['nombre'] ?? '',
      'telefono'       => $r['telefono'] ?? '',
      'puntos'    => (int)$r['puntos'],
      'maxpuntos' => (int)$r['maxpuntos'],
      'banned'         => (int)$r['banned'],
      'fechaRegistro'  => $r['fechaRegistro'] ?? null,
      'avatarURL'      => $r['avatarURL'] ?? null,
    ];
  }
  out($rows);
}

// 2) Consulta por teléfono (Carnet + flag “más pudiente”)
$tel = $_GET['telefono'] ?? '';
$tel = preg_replace('/\D+/', '', $tel);
if ($tel === '') out(['success'=>false, 'error'=>'Teléfono requerido'], 400);
if (!tableExists($mysqli, 'usuarios')) out(['success'=>false, 'error'=>'Tabla usuarios no existe'], 500);

// Usuario por teléfono
$stmt = $mysqli->prepare("SELECT id, nombre, telefono, 
                                 COALESCE(puntos,0)    AS puntos,
                                 COALESCE(maxpuntos,0) AS maxpuntos,
                                 COALESCE(banned,0)         AS banned,
                                 fechaRegistro, avatarURL
                          FROM usuarios
                          WHERE telefono=? LIMIT 1");
$stmt->bind_param('s', $tel);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();
if (!$user) out(['success'=>false, 'error'=>'No encontrado'], 404);

// Top por maxpuntos (borrachín más pudiente)
$topId = null;
try {
  $resTop = $mysqli->query("
    SELECT id 
    FROM usuarios 
    ORDER BY COALESCE(maxpuntos,0) DESC,
             COALESCE(puntos,0)    DESC,
             id ASC
    LIMIT 1
  ");
  if ($resTop && ($rowTop = $resTop->fetch_assoc())) {
    $topId = (int)$rowTop['id'];
  }
} catch (Throwable $e) {
  // si algo falla aquí, simplemente no marcamos el flag
}

$isPudiente = ($topId !== null) && ((int)$user['id'] === $topId);

out([
  'success' => true,
  'usuario' => [
    'id'             => (int)$user['id'],
    'nombre'         => $user['nombre'] ?? '',
    'telefono'       => $user['telefono'] ?? $tel,
    'puntos'    => (int)$user['puntos'],
    'maxpuntos' => (int)$user['maxpuntos'],
    'banned'         => (int)$user['banned'],
    'fechaRegistro'  => $user['fechaRegistro'] ?? null,
    'avatarURL'      => $user['avatarURL'] ?? null,
    'esBorrachinPudiente' => $isPudiente ? 1 : 0
  ]
]);
