<?php
// /api/category-settings-public.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

// 1) Conexión: reusa el mismo db.php del backend
$inc1 = __DIR__ . '/../backend/db.php';
$inc2 = __DIR__ . '/backend/db.php';
if (file_exists($inc1)) require_once $inc1;
elseif (file_exists($inc2)) require_once $inc2;
else { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'db.php not found']); exit; }

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
  // 2) Descubrir tabla y columnas reales (robusto a nombres)
  $table = table_exists($mysqli, 'category_settings') ? 'category_settings'
         : (table_exists($mysqli, 'categorias_estado') ? 'categorias_estado' : null);

  if ($table === null) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'Tabla de categorías no encontrada']); exit;
  }

  // Columnas: preferimos las que muestra tu screenshot
  $col_category = column_exists($mysqli, $table, 'category')      ? 'category'
                : (column_exists($mysqli, $table, 'category_key') ? 'category_key' : null);
  $col_message  = column_exists($mysqli, $table, 'message') ? 'message'
                : (column_exists($mysqli, $table, 'mensaje') ? 'mensaje' : null);
  $col_active   = column_exists($mysqli, $table, 'is_active') ? 'is_active'
                : (column_exists($mysqli, $table, 'activo')   ? 'activo'   : null);
  $col_updated  = column_exists($mysqli, $table, 'updated_at') ? 'updated_at' : null;

  if (!$col_category || !$col_message || !$col_active || !$col_updated) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'Columnas esperadas no existen en la tabla']); exit;
  }

  // 3) SELECT limpio contra la misma DB
  $sql = "SELECT `$col_category` AS category, `$col_message` AS message,
                 `$col_active` AS is_active, `$col_updated` AS updated_at
          FROM `$table`";
  $res = $mysqli->query($sql);

  // 4) Mapear a objeto por clave
  $map = [];
  while ($row = $res->fetch_assoc()) {
    $k = (string)$row['category'];
    $map[$k] = [
      'message'    => (string)($row['message'] ?? ''),
      'is_active'  => (int)$row['is_active'],
      'updated_at' => (string)$row['updated_at'],
    ];
  }

  echo json_encode($map, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}

// ---- helpers ----
function table_exists(mysqli $m, string $t): bool {
  $db = $m->query("SELECT DATABASE() AS db")->fetch_assoc()['db'];
  $stmt = $m->prepare("SELECT COUNT(*) AS n
                       FROM information_schema.tables
                       WHERE table_schema=? AND table_name=?");
  $stmt->bind_param('ss', $db, $t);
  $stmt->execute();
  $n = (int)$stmt->get_result()->fetch_assoc()['n'];
  return $n > 0;
}
function column_exists(mysqli $m, string $t, string $c): bool {
  $db = $m->query("SELECT DATABASE() AS db")->fetch_assoc()['db'];
  $stmt = $m->prepare("SELECT COUNT(*) AS n
                       FROM information_schema.columns
                       WHERE table_schema=? AND table_name=? AND column_name=?");
  $stmt->bind_param('sss', $db, $t, $c);
  $stmt->execute();
  $n = (int)$stmt->get_result()->fetch_assoc()['n'];
  return $n > 0;
}
