<?php
function parse_env($path){
  if(!file_exists($path)) return [];
  $env=[];
  foreach(file($path) as $l){
    $l = trim($l);
    if($l==='' || strpos($l,'#')===0 || strpos($l,'=')===false) continue;
    [$k,$v] = array_map('trim', explode('=', $l, 2));
    $env[$k]=$v;
  }
  return $env;
}
$env = parse_env(__DIR__ . '/../config/.env');

$dsn = sprintf('mysql:host=%s;port=%s;dbname=%s;charset=utf8mb4',
  $env['DB_HOST'] ?? 'localhost',
  $env['DB_PORT'] ?? '3306',
  $env['DB_NAME'] ?? '');

try {
  $pdo = new PDO($dsn, $env['DB_USER'] ?? '', $env['DB_PASS'] ?? '', [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);

  // Import dump
  $dumpPath = __DIR__ . '/../database/superca1_demo.sql';
  if(!file_exists($dumpPath)){ throw new Exception('No se encontró /database/superca1_demo.sql'); }
  $sql = file_get_contents($dumpPath);
  $sql = preg_replace('/CREATE\s+(ALGORITHM\s*=\s*\w+\s*)?(DEFINER\s*=\s*[^ ]+\s*)?(SQL\s+SECURITY\s+\w+\s*)?VIEW/mi', 'CREATE VIEW', $sql);
  $stmts = array_filter(array_map('trim', preg_split('/;\s*\n/', $sql)));
  foreach($stmts as $s){ if($s!=='') $pdo->exec($s.';'); }

  echo "✓ Demo DB installed using dump\n";

} catch(Throwable $e){
  http_response_code(500);
  echo "Error: ".$e->getMessage();
}
