<?php
// NONCE por request (16 bytes aleatorios → base64)
$CSP_NONCE = base64_encode(random_bytes(16));

/*
  CSP estricta sin 'unsafe-inline' en JS.
  - script-src: solo 'self' + scripts con NONCE + cdn.jsdelivr (para XLSX).
  - style-src: dejamos 'unsafe-inline' por compat. (Luego lo quitamos si quieres.)
  - connect-src: mismo origen (tu /api).
*/
header(
  "Content-Security-Policy: ".
  "default-src 'self'; ".
  "base-uri 'none'; object-src 'none'; frame-ancestors 'none'; ".
  "img-src 'self' data: https:; ".
  "font-src 'self' data: https:; ".
  "style-src 'self' 'unsafe-inline'; ".
  "script-src 'self' 'nonce-$CSP_NONCE' https://cdn.jsdelivr.net; ".
  "connect-src 'self'; ".
  "form-action 'self'; ".
  "upgrade-insecure-requests"
);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />

  <!-- SEO Básico -->
  <title>tienda de xxx con delivery en xxx1</title>
  <link rel="canonical" href="https://demo.supercanjes.com/">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Description optimizada (~155c) -->
  <meta name="description" content="Tutienda: venta de x ">
  <!-- Open Graph / Twitter -->
  <meta property="og:title" content="Tutienda">
  <meta property="og:description" content="tecnologia a la puerta de tu casa.">
  <meta property="og:image" content="https://demo.supercanjes.com/img/og-banner.jpg">
  <meta property="og:type" content="website">
  <meta property="og:url" content="https://demo.supercanjes.com/">
  <meta name="twitter:card" content="summary_large_image">

  <!-- Datos estructurados (rellena tu teléfono/redes si quieres) -->
<script type="application/ld+json" nonce="<?= $CSP_NONCE ?>">
{
  "@context": "https://schema.org",
  "@type": "tecnologia",
  "name": "Tu tienda",
  "url": "https://demo.supercanjes.com/",
  "image": "https://demo.superanjes.com/img/og-banner.jpg",
  "telephone": "+58 4248582308",
  "address": {
    "@type": "PostalAddress",
    "addressLocality": "Tu ciudad",
    "addressRegion": "Sucre",
    "addressCountry": "VE"
  },
  "areaServed": "Tu ciudad",
  "openingHoursSpecification": [{
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": ["Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"],
    "opens": "10:00",
    "closes": "23:59"
  }]
}
</script>


  <link rel="stylesheet" href="/styles.css?v=2025-08-14-120"/>
</head>
<body>
<header class="header">
  <!-- IZQUIERDA: referencia (Ref) -->
  <span id="tasa-bcv" class="tasa-info">Ref:(moneda/coin) 138.13</span>

  <!-- CENTRO: Brand (centrado real) -->
<div class="brand" role="banner" aria-label="Tutienda">
  <div class="brand-pill">
    <span class="sticker" aria-hidden="true">
      <img src="/sticker.gif" alt="" class="sticker-img">
    </span>
    <span class="logo-text">
      <span class="g0">S</span><span class="g1">T</span><span class="g2">O</span><span class="g3">RE</span><wbr>.COM
    </span>
  </div>
</div>


  <!-- DERECHA: (vacío) espacio por si algún día va algo -->
  <div class="header-spacer" aria-hidden="true"></div>
</header>


<div class="acciones">
  <!-- Botones dinámicos -->
  <button class="btn-registro">🎁 ¡Regístrate/Register</button>
  <button id="btn-consultar-coins" class="btn-consulta-coins">🎫 Mis puntos/My Points</button>
</div>

<header>
  <!-- Controles de usuario: saludo, login/cerrar sesión -->
  <div id="categorias-container" class="category-buttons"></div>
</header>
<div id="category-message" class="cat-msg-banner" role="status" aria-live="polite"></div>
<main class="main-layout">
  <div class="grid" id="product-grid"></div>
  
</main>


<!-- CTA: Chat + Pedir -->
<div class="cta-buttons">
  <button id="chat-toggle" class="chat-toggle" style="display:none;">💬 Chat</button>
  <button id="checkout">order</button> 
</div>

<div class="user-controls">
  <span id="user-greeting" class="user-greeting" style="display:none;"></span>
  <button id="btn-login" class="btn-login">🔑 Iniciar sesión / Login</button>
  <button id="btn-logout" class="btn-logout" style="display:none;">Cerrar sesión / Log out</button> 
</div>

<!-- ============================= -->
<!-- Modal de Resumen de Pedido   -->
<!-- ============================= -->
<div id="modal-summary" class="modal" style="display:none;">
  <div class="modal-content summary-modal">
    <span class="close-modal">&times;</span>
    <h2>Resumen/purchase summary</h2>
    <div id="summary-user"></div>
    <ul id="summary-list"></ul>
    <div id="summary-total"></div>

    <div class="extra-fields">
      <p><strong>📦 Despacho/shipping:</strong></p>
      <div class="options-row">
        <label><input type="radio" name="despacho" value="Delivery"> Delivery</label>
        <label><input type="radio" name="despacho" value="Retiro en tienda"> Retiro en tienda/store pickup</label>
      </div>
      <p><strong>💳 Método de Pago/Payment method:</strong></p>
      <div class="options-row">
        <label><input type="radio" name="metodo" value="Pago Móvil"> Transferencia/transferens</label>
        <label><input type="radio" name="metodo" value="Tarjeta"> Tarjeta/card</label>
        <label><input type="radio" name="metodo" value="Efectivo"> Efectivo/cash</label>
      </div>
    </div>

    <button id="confirm-pea" class="confirm-btn">Confirmar/confirm</button>
  </div>
</div>

<!-- ============================= -->
<!-- Modal de Registro de Usuario -->
<!-- ============================= -->
<div id="modal-registro" class="modal-registro" style="display: none;">
  <div class="modal-registro-content">
    <span class="cerrar-registro">&times;</span>
    <h2>✨ Bienvenido a TuTienda.com</h2>
 
    <div class="registro-form">
      <input type="text" id="nombre" placeholder="Nombre o Apodo/name" />
      <div class="tel-group">
        <select id="codigo-operadora">
          <option value="0412">0412</option>
          <option value="0414">0414</option>
          <option value="0424">0424</option>
          <option value="0416">0416</option>
          <option value="0426">0426</option>
          <option value="0422">0422</option>
        </select>
        <input type="text" id="telefono" placeholder="Num de telf/phone number" maxlength="7" />
      </div>
      <button id="enviar-registro">Registrarme/register</button>
      <p class="registro-error" style="display: none;"></p>
    </div>
    <p class="registro-sub">
      Regístrate y recibe <strong>0.10$</strong> de bienvenida.<br>
      Acumula monedas y cámbialas por <span class="destacar">descuentos</span> o <span class="destacar">Retiros</span>.
    </p>
  </div>
</div>

<!-- ============================= -->
<!-- Modal de Éxito de Registro   -->
<!-- ============================= -->
<div id="modal-registro-exito" class="modal-registro-exito" style="display: none;">
  <div class="modal-exito-content">
    <h2>✅ Registro Exitoso</h2>
    <p>Consulta tus puntos/check your points</p>
    <button class="cerrar-exito">X</button>
  </div>
</div>

<!-- ============================= -->
<!-- Overlay puntos (Carnet)  -->
<!-- ============================= -->
<div id="coinsModalOverlay" class="coins-modal-overlay" hidden>
  <div class="carnet" id="carnetUsuario" style="display:none;">
    <button type="button" class="carnet-close" aria-label="Cerrar">×</button>
    <p class="carnet-title">Socio/Partner</p>
    <div class="carnet-body">
      <img src="avatar.jpg" alt="Avatar" class="avatar" />
      <div class="info">
        <p class="name"><span>-</span></p>
        <p class="coins">puntos/points: <span>0</span></p>
        <p class="categoria">Categoría/category: <span>—</span></p>
        <p id="carnet-premios">Premio disponible/price available: —</p>
        <button id="btnReclamarPremio" class="btn-reclamar">Reclamar/claim</button>
      </div>
    </div>
  </div>
</div>




<!-- ============================= -->
<!-- Modal: Inicio de Sesión      -->
<!-- ============================= -->
<div id="login-modal" class="modal-login" style="display:none;">
  <div class="login-modal-content">
    <span class="login-close">&times;</span>
    <h2>🔑 Iniciar sesión/login</h2>
    <p>Introduce tu número de teléfono/input your number phone</p>
    <input type="text" id="login-phone" placeholder="Admin:04121234567" maxlength="11" pattern="\d{11}" />
    <p class="login-error" id="login-error" style="display:none;"></p>
    <button id="login-confirm" class="login-confirm">Entrar / Enter</button>
  </div>
</div>

<!-- ============================= -->
<!-- Chat Global Overlay          -->
<!-- ============================= -->
<!-- CHAT OVERLAY -->
<div id="chat-overlay" class="chat-overlay" hidden aria-hidden="true">
  <div class="chat-box chat-theme-soft" role="dialog" aria-label="Chat Mi Comunidad">
    <button id="chat-close" class="chat-close" aria-label="Cerrar chat">✕</button>

    <!-- HERO: foto rectangular tipo carnet + títulos -->
    <section class="chat-hero">
      <img id="chat-president-avatar" class="chat-avatar-card" alt="Foto del Presidente/president photo">
      <h3 id="chat-president-name" class="chat-hero-name">President</h3>
      <p id="chat-president-title" class="chat-hero-title">President</p>

      <!-- Visible solo si el usuario logueado es el top -->
      <label id="president-photo-label" class="president-photo-btn" for="president-photo-input">Subir mi foto/upload my photo</label>
      <input id="president-photo-input" type="file" accept="image/*" hidden>
    </section>

    <!-- MENSAJES -->
    <section id="chat-messages" class="chat-messages" role="log" aria-live="polite"></section>

    <!-- BARRA DE ADJUNTOS PREVIA -->
    <div id="chat-attach-bar" class="chat-attach-bar" hidden></div>

    <!-- INPUT + EMOJIS + ARCHIVOS -->
    <form class="chat-input" onsubmit="return false">
      <label class="icon-btn" for="chat-file-input" title="Adjuntar archivos" aria-label="Adjuntar archivos">📎</label>
      <input id="chat-file-input" type="file" multiple hidden accept="image/*,video/*,audio/*,.pdf,.doc,.docx,.xls,.xlsx,.txt">
      <input id="chat-message-input" type="text" placeholder="write/Escribe tu mensaje…" autocomplete="off">
      <button id="chat-send" type="button">Enviar / Send</button>
    </form>
  </div>
</div>


<!-- ============================= -->
<!-- Video publicitario            -->
<!-- ============================= 
<div id="promoVideoModal" class="promo-modal" style="display:none">
  <div class="promo-wrap">
    <button id="closePromoVideo" class="promo-close" aria-label="Cerrar">✕</button>
    <video id="promoVideo" autoplay muted playsinline preload="metadata" controls></video>
  </div>
</div>
-->
<!-- Base de API (antes de los JS) -->
<script nonce="<?= $CSP_NONCE ?>">
  window.BACKEND = '/api/';
</script>

<!-- Scripts (defer para no bloquear la carga) -->
<script src="https://cdn.jsdelivr.net/npm/xlsx@0.18.5/dist/xlsx.full.min.js" defer></script>

<script src="registro.js?v=2025-08-14-22" defer></script>
<script src="/chat.js?v=2025-08-14-39" defer></script>
<script src="script.js?v=2025-08-14-65" defer></script>

<div id="neon-alert" class="neon-alert"></div>


</body>
</html>
