<?php
// config/config.php — centraliza lectura de .env
$envPath = __DIR__ . '/.env';
if (!is_readable($envPath)) {
  throw new Exception('No se encontró config/.env. Copia config/.env.example a config/.env y edítalo.');
}
$env = parse_ini_file($envPath, false, INI_SCANNER_RAW);

if (!defined('APP_URL'))    define('APP_URL',    $env['APP_URL']    ?? '');
if (!defined('DB_HOST'))    define('DB_HOST',    $env['DB_HOST']    ?? 'localhost');
if (!defined('DB_PORT'))    define('DB_PORT',    (int)($env['DB_PORT'] ?? 3306));
if (!defined('DB_NAME'))    define('DB_NAME',    $env['DB_NAME']    ?? 'superca1_demo');
if (!defined('DB_USER'))    define('DB_USER',    $env['DB_USER']    ?? 'superca1_userdemo');
if (!defined('DB_PASS'))    define('DB_PASS',    $env['DB_PASS']    ?? 'Demosuper2846*');
if (!defined('DB_CHARSET')) define('DB_CHARSET', $env['DB_CHARSET'] ?? 'utf8mb4');
