<?php
// /backend/upload_president.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

require_once dirname(__DIR__) . '/backend/db.php'; 
$mysqli->set_charset('utf8mb4');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { echo json_encode(['success'=>false,'error'=>'Método no permitido']); exit; }

$telefono = preg_replace('/\D+/', '', $_POST['telefono'] ?? '');
if (!$telefono) { echo json_encode(['success'=>false,'error'=>'Teléfono requerido']); exit; }

$st = $mysqli->prepare("SELECT id FROM usuarios WHERE telefono=? LIMIT 1");
$st->bind_param('s', $telefono);
$st->execute(); $u = $st->get_result()->fetch_assoc(); $st->close();
if (!$u){ echo json_encode(['success'=>false,'error'=>'Usuario no encontrado']); exit; }

// Verifica top en este instante
$resTop = $mysqli->query("
  SELECT id FROM usuarios
  ORDER BY COALESCE(maxpuntos,0) DESC,
           COALESCE(puntos,0)    DESC,
           id ASC
  LIMIT 1
");
$top = $resTop ? $resTop->fetch_assoc() : null;
if (!$top || (int)$top['id'] !== (int)$u['id']) {
  echo json_encode(['success'=>false,'error'=>'No eres el borrachín más pudiente']); exit;
}

if (!isset($_FILES['foto']) || $_FILES['foto']['error'] !== UPLOAD_ERR_OK) {
  echo json_encode(['success'=>false,'error'=>'Archivo no recibido']); exit;
}
$ext = strtolower(pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION));
if (!in_array($ext, ['jpg','jpeg','png','gif','webp'])) {
  echo json_encode(['success'=>false,'error'=>'Formato no permitido']); exit;
}

$dir = __DIR__ . '/../uploads/president/';
if (!is_dir($dir)) { @mkdir($dir, 0775, true); }

$filename = 'presidente_' . (int)$u['id'] . '.' . $ext;
$path = $dir . $filename;
if (!move_uploaded_file($_FILES['foto']['tmp_name'], $path)) {
  echo json_encode(['success'=>false,'error'=>'No se pudo guardar la imagen']); exit;
}
$url = '/uploads/president/' . $filename;

$st = $mysqli->prepare("UPDATE usuarios SET avatarURL=? WHERE id=?");
$st->bind_param('si', $url, $u['id']);
$st->execute(); $st->close();

echo json_encode(['success'=>true, 'url'=>$url]);
