<?php
// backend/diag.php — SOLO LECTURA (protegido por token)
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

const TOKEN = 'pon_aqui_un_token_largo_y_unico';

if (!isset($_GET['token']) || $_GET['token'] !== TOKEN) {
  http_response_code(403);
  echo json_encode(['ok'=>false,'error'=>'FORBIDDEN']);
  exit;
}

$resp = ['ok'=>true, 'ts'=>date('c'), 'php'=>PHP_VERSION];
try {
  require_once __DIR__ . '/db.php';
  $mysqli->set_charset('utf8mb4');
  mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

  // Tablas
  $tables = [];
  $rs = $mysqli->query("SHOW TABLES");
  while ($r = $rs->fetch_array(MYSQLI_NUM)) $tables[] = $r[0];
  $resp['tables'] = $tables;

  // Helper columnas
  function describeTable($mysqli, $table) {
    try {
      $cols = [];
      $rs = $mysqli->query("DESCRIBE `{$table}`");
      while ($r = $rs->fetch_assoc()) $cols[] = $r;
      return $cols;
    } catch (Throwable $e) { return null; }
  }

  // Columnas clave
  $resp['columns'] = [
    'productos'          => in_array('productos', $tables) ? describeTable($mysqli, 'productos') : null,
    'categorias_estado'  => in_array('categorias_estado', $tables) ? describeTable($mysqli, 'categorias_estado') : null,
  ];

  // Conteos y muestras
  if (in_array('productos', $tables)) {
    // Conteo por is_active
    $cnt = [];
    $rs = $mysqli->query("SELECT COALESCE(is_active,1) as is_active, COUNT(*) c FROM productos GROUP BY COALESCE(is_active,1)");
    while ($r = $rs->fetch_assoc()) $cnt[$r['is_active']] = (int)$r['c'];
    $resp['productos_counts'] = ['activos'=>($cnt[1]??0), 'inactivos'=>($cnt[0]??0)];

    // Muestra de inactivos (hasta 20)
    $sampleInact = [];
    if (($cnt[0]??0) > 0) {
      $rs = $mysqli->query("SELECT id, category, name, price, img, is_active FROM productos WHERE COALESCE(is_active,1)=0 ORDER BY id DESC LIMIT 20");
      while ($r = $rs->fetch_assoc()) $sampleInact[] = $r;
    }
    $resp['productos_inactivos_sample'] = $sampleInact;

    // Distribución por categoría
    $byCat = [];
    $rs = $mysqli->query("SELECT category, SUM(COALESCE(is_active,1)=1) as activos, SUM(COALESCE(is_active,1)=0) as inactivos, COUNT(*) as total
                          FROM productos GROUP BY category ORDER BY category");
    while ($r = $rs->fetch_assoc()) $byCat[] = $r;
    $resp['productos_por_categoria'] = $byCat;
  }

  // Estado de categorías si existe la tabla
  if (in_array('categorias_estado', $tables)) {
    $rows = [];
    $rs = $mysqli->query("SELECT category, COALESCE(is_active,1) as is_active, COALESCE(message,'') as message FROM categorias_estado ORDER BY category");
    while ($r = $rs->fetch_assoc()) $rows[] = $r;
    $resp['categorias_estado'] = $rows;
  }

  // Vistazo del árbol de imágenes (limitado)
  $resp['imgs'] = [];
  $docroot = realpath($_SERVER['DOCUMENT_ROOT'] ?: dirname(__DIR__,1));
  $base = $docroot ? ($docroot . '/imgproductos') : null;
  if ($base && is_dir($base)) {
    $cats = array_slice(glob($base.'/*', GLOB_ONLYDIR) ?: [], 0, 20);
    foreach ($cats as $dir) {
      $cat = basename($dir);
      $files = glob($dir.'/*.{webp,jpg,jpeg,png,WEBP,JPG,JPEG,PNG}', GLOB_BRACE) ?: [];
      $resp['imgs'][] = ['category'=>$cat, 'files'=>array_slice(array_map('basename',$files), 0, 15), 'count'=>count($files)];
    }
  }
} catch (Throwable $e) {
  $resp['ok'] = false;
  $resp['error'] = $e->getMessage();
}

echo json_encode($resp, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
