<?php
// db.php — inicializa una conexión mysqli usando los parámetros definidos en
// config.php. Si no existen dichas constantes, utiliza valores por defecto.

// Intenta cargar la configuración central si existe. Esto permite definir
// constantes como DB_HOST, DB_USER, etc. en un único lugar (ver
// backend/config.php) y reutilizarlas desde distintos módulos.
@require_once __DIR__ . '/config.php';

// Obtiene parámetros de conexión, respetando constantes definidas.
$host    = defined('DB_HOST')    ? DB_HOST    : 'localhost';
$user    = defined('DB_USER')    ? DB_USER    : 'superca1_userdemo';
$pass    = defined('DB_PASS')    ? DB_PASS    : 'Demosuper*';
$dbName  = defined('DB_NAME')    ? DB_NAME    : 'superca1_demo';
$charset = defined('DB_CHARSET') ? DB_CHARSET : 'utf8mb4';

// Crea la conexión. En caso de error, devuelve un JSON de error y termina.
$mysqli = @new mysqli($host, $user, $pass, $dbName);
if ($mysqli === null || $mysqli->connect_errno) {
    // No lanzar warnings de PHP aquí, ya que podríamos estar en contexto de API.
    http_response_code(500);
    echo json_encode(['error' => 'Error de conexión']);
    exit;
}

// Establece el conjunto de caracteres. Si falla, mysqli emitirá un aviso.
$mysqli->set_charset($charset);
?>