<?php
// /api/pudiente.php
// Devuelve el usuario con mayor maxpuntos.

declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

require_once dirname(__DIR__) . '/backend/db.php';

$mysqli->set_charset('utf8mb4');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 0);

function out($arr, int $code=200){ http_response_code($code); echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }

$q = $mysqli->query(
  "SELECT id, nombre, phone_e164, COALESCE(avatarURL,'') AS avatarURL, COALESCE(maxpuntos,0) AS maxpuntos, COALESCE(puntos,0) AS puntos FROM usuarios ORDER BY COALESCE(maxpuntos,0) DESC, COALESCE(puntos,0) DESC, id ASC LIMIT 1"
);
$top = $q ? $q->fetch_assoc() : null;
if (!$top) out(['success'=>false, 'error'=>'No hay usuarios']);

$avatarURL = trim((string)$top['avatarURL']);
$ver = time();
if ($avatarURL !== '') {
  $fsPath = __DIR__ . '/../' . ltrim($avatarURL, '/');
  if (is_file($fsPath)) {
    $ver = (int) @filemtime($fsPath);
  }
  $sep = (strpos($avatarURL, '?') !== false) ? '&' : '?';
  $avatarURL .= $sep . 'v=' . $ver;
}

out([
  'success' => true,
  'top' => [
    'id'             => (int)$top['id'],
    'nombre'         => $top['nombre'] ?? '',
    'telefono'       => $top['phone_e164'] ?? '',
    'avatarURL'      => $avatarURL,
    'maxpuntos' => (int)$top['maxpuntos']
  ]
]);
?>